import React, { useState, useEffect, useRef } from "react";
import { I18nManager, Platform, StyleSheet, View, useWindowDimensions } from "react-native";
import Animated, {
    useSharedValue,
    useAnimatedRef,
    useAnimatedScrollHandler,
} from "react-native-reanimated";
import Pagination from "./Pagination";
import BannerRenderItem from "./BannerRenderItem";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

const ImageCarousel = ({ data, autoPlay, pagination }) => {
    const interval = useRef();
    const scrollViewRef = useAnimatedRef(null);
    const [isAutoPlay, setIsAutoPlay] = useState(autoPlay);
    const { width } = useWindowDimensions();
    const SIZE = Math.floor(width+3 - dpr(40));
    const initShareValue = I18nManager.isRTL ? SIZE * (data?.length - 1) : 0;
    const x = useSharedValue(initShareValue);
    const offSet = useSharedValue(initShareValue);
    const onScroll = useAnimatedScrollHandler({
        onScroll: (event) => {
            x.value = event.contentOffset.x;
        },
    });

    useEffect(() => {
        if (isAutoPlay === true) {
            let _offSet = offSet.value;
            interval.current = setInterval(() => {
                if (_offSet >= Math.floor(SIZE * (data?.length - 1) - 10)) {
                    _offSet = 0;
                } else {
                    _offSet = Math.floor(_offSet + SIZE);
                }
                scrollViewRef.current.scrollTo({ x: _offSet, y: 0 });
            }, 2000);
        } else {
            clearInterval(interval.current);
        }
    }, [SIZE, isAutoPlay, data?.length, offSet.value, scrollViewRef]);

    return (
        <View>
            <Animated.ScrollView
                ref={scrollViewRef}
                onScroll={onScroll}
                onScrollBeginDrag={() => {
                    setIsAutoPlay(false);
                }}
                onMomentumScrollEnd={(e) => {
                    Platform.OS === "android" && (offSet.value = e.nativeEvent.contentOffset.x);
                    autoPlay && setIsAutoPlay(true);
                }}
                scrollEventThrottle={16}
                decelerationRate='fast'
                snapToInterval={SIZE}
                horizontal
                bounces={false}
                showsHorizontalScrollIndicator={false}
            >
                {data?.map((item, index) => {
                    return (
                        <View style={Styles({SIZE}).bannerRenderItemView} key={index}>
                            <BannerRenderItem item={item} />
                        </View>
                    );
                })}
            </Animated.ScrollView>
            {pagination && <Pagination data={data} x={x} size={SIZE} />}
        </View>
    );
};

export default ImageCarousel;

const Styles = (props) => StyleSheet.create({
    bannerRenderItemView: {
        width: props.SIZE
    }
});